------------------------------------------------------------------------
-- Event:        Delphi Day 2018, Piacenza, June 06 2018               -
--               https://www.delphiday.it/                             -
-- Seminary:     How to write high performance queries in T-SQL        -
-- Demo:         PIVOT                                                 -
-- Author:       Sergio Govoni                                         -
-- Notes:        --                                                    -
------------------------------------------------------------------------

USE [WideWorldImporters];
GO


IF OBJECT_ID('dbo.Measures') IS NOT NULL
  DROP TABLE dbo.Measures;

CREATE TABLE dbo.Measures
(
  MachineID INT NOT NULL
  ,Attribute NVARCHAR(30) NOT NULL
  ,Value SQL_VARIANT NOT NULL
  PRIMARY KEY (MachineID, Attribute)
);
GO

INSERT INTO dbo.Measures
(
  MachineID
  ,Attribute
  ,Value
)
VALUES
(1, N'attr1', CAST(CAST('ABC' AS VARCHAR(10))   AS SQL_VARIANT)),
(1, N'attr2', CAST(CAST(10 AS INT) AS SQL_VARIANT)),
(1, N'attr3', CAST(CAST('20180101' AS SMALLDATETIME) AS SQL_VARIANT)),
(2, N'attr2', CAST(CAST(12 AS INT) AS SQL_VARIANT)),
(2, N'attr3', CAST(CAST('20170101' AS SMALLDATETIME) AS SQL_VARIANT)),
(2, N'attr4', CAST(CAST('K' AS CHAR(1)) AS SQL_VARIANT)),
(2, N'attr5', CAST(CAST(13.7 AS NUMERIC(9,3)) AS SQL_VARIANT)),
(3, N'attr1', CAST(CAST('D18' AS VARCHAR(10)) AS SQL_VARIANT)),
(3, N'attr2', CAST(CAST(20 AS INT) AS SQL_VARIANT)),
(3, N'attr3', CAST(CAST('20180606' AS SMALLDATETIME) AS SQL_VARIANT));


SELECT * FROM dbo.Measures;
GO


-- Step 1: Come sono correlate le righe della sorgente e della destinazione?
-- serve probabilmente un raggruppamento, quale elemento deve essere raggruppato?
-- in questo esempio il raggruppamento deve essere eseguito per la colonna MachineID
-- Step 1: "grouping"





-- Step 2: Pensiamo ora alle colonne
-- si desidera avere una colonna per ogni attributo, quindi in questo esempio
-- di dovranno avere 5 colonne (attr1, attr2, attr3, attr4, attr5)
-- Step 2: "spreading"






-- Step 3: Estrarre i valori conosciuti.. per la presenza del raggruppamento
--  necessario utilizzare una funzione di aggregazione ad esempio MAX o MIN
-- (entrambe ignorano i valori NULL). L'elemento da aggregare  la "colonna" value
-- Step 3: "aggregation"


SELECT * FROM dbo.Measures;
GO

-- Pivoting, senza l'utilizzo dell'operatore PIVOT
SELECT
  MachineID
  ,MAX(CASE WHEN Attribute = 'attr1' THEN Value END) AS attr1
  ,MAX(CASE WHEN Attribute = 'attr2' THEN Value END) AS attr2
  ,MAX(CASE WHEN Attribute = 'attr3' THEN Value END) AS attr3
  ,MAX(CASE WHEN Attribute = 'attr4' THEN Value END) AS attr4
  ,MAX(CASE WHEN Attribute = 'attr5' THEN Value END) AS attr5
FROM
  dbo.Measures
GROUP BY
  MachineID;
GO



-- Pivoting con utilizzo dell'operatore PIVOT
SELECT
  MachineID
  ,attr1
  ,attr2
  ,attr3
  ,attr4
  ,attr5
FROM
  dbo.Measures
  PIVOT(
         MAX(Value) /*Step: aggregation*/ FOR Attribute /*Step: spread by*/

         IN([attr1], [attr2], [attr3], [attr4], [attr5])
	   ) AS P;
  /*
    Step: grouping
	
	Dove  il grouping ?

	E' determinato automaticamente!!! o_0

	Gli elementi di raggruppamento sono rappresentati dalla lista delle colonne
	della tabella di input - non specificate nella altre fasi - MachineID
  */
GO


/*
ALTER TABLE dbo.Measures DROP COLUMN ModifyDate;
GO
*/

ALTER TABLE dbo.Measures ADD ModifyDate DATETIME2
GO

UPDATE
  dbo.Measures
SET
  ModifyDate = GETDATE()
WHERE
  (MachineID = 1)
  AND (Attribute = 'attr1');
GO

UPDATE
  dbo.Measures
SET
  ModifyDate = GETDATE()
WHERE
  (MachineID = 3) AND (Attribute = 'attr2');
GO


-- Pivoting con utilizzo dell'operatore PIVOT e tabella derivata
SELECT
  MachineID
  ,attr1
  ,attr2
  ,attr3
  ,attr4
  ,attr5
FROM
  (SELECT MachineID, Attribute, [Value] FROM dbo.Measures) AS PivotTab
  PIVOT(
         MAX(Value) FOR Attribute 

         IN([attr1], [attr2], [attr3], [attr4], [attr5])
	   ) AS P;
GO


-- Ora che abbiamo imparato la logica vediamo un esempio pratico

USE [WideWorldImporters];
GO

/*
SELECT DATEADD(DAY, 42529, '18991230');

SELECT
  YEAR(DATEADD(DAY, MIN(datdoc), '18991230')),
  YEAR(DATEADD(DAY, MAX(datdoc), '18991230'))
FROM dbo.FATTES;
*/


SELECT
  CustomerID
  ,OrderDate
  ,TotalDue
FROM
  Sales.SalesOrderHeader
ORDER BY
  CustomerID;
GO


SELECT
  P.*
FROM
  (
   SELECT
     CustomerID /*Step: grouping*/
	 ,YEAR(OrderDate) AS OrderYear
	 ,TotalDue
   FROM
     Sales.SalesOrderHeader
  ) AS F
PIVOT
  (
   SUM(TotalDue) /*Step: aggregation*/ FOR OrderYear /*Step: spread by*/
   IN ([2010], [2011], [2012], [2013], [2014], [2015], [2016], [2017], [2018])
  ) AS P;
GO


-- Memorizziamo i dati
SELECT
  P.*
INTO
  Sales.TempDDay18
FROM
  (
   SELECT
     CustomerID /*Step: grouping*/
     ,YEAR(OrderDate) AS OrderYear
	 ,TotalDue
   FROM
     Sales.SalesOrderHeader
  ) AS F
PIVOT
  (
   SUM(TotalDue) /*Step: aggregation*/ FOR OrderYear /*Step: spread by*/
   IN ([2010], [2011], [2012], [2013], [2014], [2015], [2016], [2017], [2018])
  ) AS P;
GO


SELECT * FROM Sales.TempDDay18;
GO